#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include common_scripts\utility;
#include user_scripts\mp_patches\hawkins\setup;
#include user_scripts\mp_patches\hawkins\hud;
#include user_scripts\mp_patches\hawkins\utils;

spawnModel(model, pos, angle){
    c=spawn("script_model", pos);
    c.angles=angle;
    c setModel(model);
    if(isSubStr(model, "com_plasticcase"))
        c CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
}

CreatePlatform(start, end, angle) {
    Asc = spawn("script_model", end);
    Asc setModel("com_plasticcase_friendly");
    Asc.angles = angle;
    Asc Solid();
    Asc CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    Asc thread PlatformThink(start, end);
}

PlatformThink(start, end) {
    time = distance(start, end)*0.015;
    while (isDefined(self)) {
        self MoveTo(start, time);
        wait time+2;
        self MoveTo(end, time);
        wait time+2;
    }
}

CreatePlate(corner1, corner2, arivee, angle, time)
{
	W = Distance((corner1[0], 0, 0), (corner2[0], 0, 0));
	L = Distance((0, corner1[1], 0), (0, corner2[1], 0));
	H = Distance((0, 0, corner1[2]), (0, 0, corner2[2]));
	CX = corner2[0] - corner1[0];
	CY = corner2[1] - corner1[1];
	CZ = corner2[2] - corner1[2];
	ROWS = roundUp(W/55);
	COLUMNS = roundUp(L/30);
	HEIGHT = roundUp(H/20);
	XA = CX/ROWS;
	YA = CY/COLUMNS;
	ZA = CZ/HEIGHT;
	center = spawn("script_origin", corner1);
	for(r = 0; r <= ROWS; r++){
		for(c = 0; c <= COLUMNS; c++){
			for(h = 0; h <= HEIGHT; h++){
				block = spawn("script_model", (corner1 + (XA * r, YA * c, ZA * h)));//ok
				block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
				block.angles = (0, 0, 0);
				block Solid();
				block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
				block thread Escalatore((corner1 + (XA * r, YA * c, ZA * h)), (arivee + (XA * r, YA * c, ZA * h)), time);
			}
		}
	}
	center.angles = angle;
	center thread Escalatore(corner1, arivee, time);
	center CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
}

Escalatore(depart, arivee, time)
{
	while(isDefined(self))
	{
		if(self.state == "open")
		{
			self MoveTo(depart, time);
			wait (time*2.5);
			self.state = "close";
			continue;
		}
		if(self.state == "close")
		{
			self MoveTo(arivee, time);
			wait (time*2.5);
			self.state = "open";
			continue;
		}
		wait 1;
	}
}

CreateAsc(depart, arivee, angle, time)
{
	Asc = spawn("script_model", depart );
	Asc setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
	Asc.angles = angle;
	Asc Solid();
	Asc CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	Asc thread Escalator(depart, arivee, time);
}

Escalator(depart, arivee, time)
{
	level waittill("CREATED");
	while(1)
	{
		if(self.state == "open")
		{
			self MoveTo(depart, time);
			wait time;
			self.state = "close";
		}
		else if(self.state == "close")
		{
			self MoveTo(arivee, time);
			wait time;
			self.state = "open";
		}
		wait 0.025;
		wait time;
	}
}

CreateCircle(depart, pass1, pass2, pass3, pass4, arivee, angle, time)
{
	Asc = spawn("script_model", depart );
	Asc setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
	Asc.angles = angle;
	Asc Solid();
	Asc CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	
	Asc thread Circle(depart, arivee, pass1, pass2, pass3, pass4, time);
}

Circle(depart, pass1, pass2, pass3, pass4, arivee, time)
{
	level waittill("CREATED");
	while(1)
	{
		if(self.state == "open")
		{
			self MoveTo(depart, time);
			wait time;
			self.state = "op";
		}
		else if(self.state == "op")
		{
			self MoveTo(pass1, time);
			wait time;
			self.state = "opi";
		}
		else if(self.state == "opi")
		{
			self MoveTo(pass2, time);
			wait time;
			self.state = "opa";
		}
		else if(self.state == "opa")
		{
			self MoveTo(pass3, time);
			wait time;
			self.state = "ope";
		}
		else if(self.state == "ope")
		{
			self MoveTo(pass4, time);
			wait time;
			self.state = "close";
		}
		else if(self.state == "close")
		{
			self MoveTo(arivee, time);
			wait time;
			self.state = "open";
		}
		wait 0.015;
		wait time;
	}
}

createFlag(enter, exit, angle)
{
	flag = spawn( "script_model", enter );
	flag setModel( "h1_flag_mp_domination_usmc_blue" );
	//flag thread WaitToLight(enter);
	flag showInMap();

	flag = spawn( "script_model", exit );
	flag setModel( "h1_flag_mp_domination_usmc_red" );
	//flag thread WaitToLight(exit);


	self thread flagLogic(enter, exit, angle);
}

ScreateSecretFlag(enter, exit, angle)
{
	flag = spawn( "script_model", enter );
	flag setModel( "h1_flag_mp_domination_usmc_blue" );
	//thread WaitToLight(enter);
	flag showInMap();
	self thread secretFlagLogic(enter, exit, angle);
}

CreateHiddenFlag(enter, exit, angle)
{
	self thread flagLogic(enter, exit, angle);
}

WaitToLight(enter)
{
	while(1){
		level waittill("newPlayerSpawned");
		wait 2;
		playFx( level.customFX["red_blink_light"], enter );
	}
}

flagLogic(enter, exit, angle)
{
	self endon("disconnect");
	while(1){
		foreach(player in level.players){
			if(Distance(enter, player.origin) <= 50 && isAlive(player))
			{
				player SetOrigin(exit);
				player SetPlayerAngles(angle);
			}
		}
		wait 0.025;
	}
}

secretFlagLogic(enter, exit, angle)
{
	self endon("disconnect");
	Elev = spawn( "trigger_radius", enter, 0, 35, 35 );
	Elev.angles = angle;
	while(1)
	{
		foreach(player in level.players){
			if(Distance(enter, player.origin) <= 50 && isAlive(player))
			{
				player SetOrigin(exit);
				player SetPlayerAngles(angle);
				iprintlnBold(self.name+" ^5Has Found a ^1Secret Flag!");
				player playsound("mp_war_objective_lost");
			}
		}
		wait 0.025;
	}
}

showInMap()
{
	self endon ( "disconnect" ); 
	self endon ( "death" ); 
	i = maps\mp\gametypes\_gameobjects::getNextObjID();	
	name = precacheShader( "compass_waypoint_panic" );	
	objective_add( i, "invisible", (0,0,0) );
	objective_position( i, self.origin );
	objective_state( i, "active" );
	objective_team( i, self.team );
	objective_icon( i, name );
	self.objIdFriendly = i;
}

CreateTWall(enter, exit, radius)
{
	flag = spawn( "script_origin", enter );
	//flag setModel("tag_origin");
	self thread TWallAct(enter, exit, radius);
}

TWallAct(enter, exit, radius)
{
	self endon("disconnect");
	while(1)//OK
	{
		foreach(player in level.players)
		{
			if(Distance(enter, player.origin) <= radius && isAlive(player))
			{
				player SetOrigin(exit);
				playFX(level.customFX["large_vehicle_explosion"], exit);
				player playsound("mp_war_objective_lost");
			}
		}
		wait 1.5;
	}
}

CreateTurret(pos, angles, Tammo)
{
	T = spawnTurret( "misc_turret", pos , "pavelow_minigun_mp" ); 
    T setModel( "weapon_minigun" );
    T.angles = (angles);
	T SetLeftArc(360);
	T SetRightArc(360);
	T thread manageZombies(pos);
}
manageZombies(pos)
{
	while(1){
		foreach(player in level.players){
			if(player.team == "axis" && isAlive(player)){
				if(player isusingturret())
					player suicide();
			}
		}
		wait 1.5;
	}
}
	
CreateBlocks(pos, angle)
{
	block = spawn("script_model", pos );
	block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
	block.angles = angle;
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
}
CreateIBlock(pos, angle)
{
	block = spawn("script_model", pos );
	//block setModel("tag_origin");
	block.angles = angle;
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
}
CreateRamps(top, bottom)
{
	D = Distance(top, bottom);
	blocks = roundUp(D/30);
	CX = top[0] - bottom[0];
	CY = top[1] - bottom[1];
	CZ = top[2] - bottom[2];
	XA = CX/blocks;
	YA = CY/blocks;
	ZA = CZ/blocks;
	CXY = Distance((top[0], top[1], 0), (bottom[0], bottom[1], 0));
	Temp = VectorToAngles(top - bottom);
	BA = (Temp[2], Temp[1] + 90, Temp[0]);
	for(b = 0; b < blocks; b++){
		block = spawn("script_model", (bottom + ((XA, YA, ZA) * b)));
		block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = BA;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	}
	block = spawn("script_model", (bottom + ((XA, YA, ZA) * blocks) - (0, 0, 5)));
	block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
	block.angles = (BA[0], BA[1], 0);
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
}

CreateGrids(corner1, corner2, angle)
{
	W = Distance((corner1[0], 0, 0), (corner2[0], 0, 0));
	L = Distance((0, corner1[1], 0), (0, corner2[1], 0));
	H = Distance((0, 0, corner1[2]), (0, 0, corner2[2]));
	CX = corner2[0] - corner1[0];
	CY = corner2[1] - corner1[1];
	CZ = corner2[2] - corner1[2];
	ROWS = roundUp(W/55);
	COLUMNS = roundUp(L/30);
	HEIGHT = roundUp(H/20);
	XA = CX/ROWS;
	YA = CY/COLUMNS;
	ZA = CZ/HEIGHT;
	center = spawn("script_origin", corner1);
	for(r = 0; r <= ROWS; r++){
		for(c = 0; c <= COLUMNS; c++){
			for(h = 0; h <= HEIGHT; h++){
				block = spawn("script_model", (corner1 + (XA * r, YA * c, ZA * h)));
				block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
				block.angles = (0, 0, 0);
				block Solid();
				block LinkTo(center);
				block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
			}
		}
	}
	center.angles = angle;
}
CreateFire(pos)
{	
	Flam = spawn( "script_origin", pos );
	//Flam setModel("tag_origin");
	angles = (90,90,0);	
	Flam thread doMapfire(pos);
	//Flam thread FBurn(pos);
	Flam thread FTrig(pos);
}
doMapfire(pos)
{	
	self endon("disconnect");
	while(isDefined(self))
	{
		playFX(level.customFX["fire_smoke"], pos);
		wait 0.1;
	}
}

FTrig(pos)
{
	self endon("disconnect");
	level.FTrig = spawn( "trigger_radius", pos, 0, 35, 35 );
	level.FTrig thread FTrigWait(pos,self);
}

FTrigWait(pos,Flam)
{
	self endon("death");
	level endon("game_ended");
	while(isdefined(self))
	{
	self waittill( "trigger", player );
	if(Distance(Flam.origin, player.origin) <= 100)
		{	
		if(player.team == "axis") 
			{
				player playlocalsound( "breathing_hurt" );
				RadiusDamage( pos, 70, 15, 10);
				wait .2;
				earthquake( 0.4, 0.75, player.origin, 512 );
			}
		}
	wait 0.2;
	}
}
CreateWalls(start, end)
{
	D = Distance((start[0], start[1], 0), (end[0], end[1], 0));
	H = Distance((0, 0, start[2]), (0, 0, end[2]));
	blocks = roundUp(D/55);
	height = roundUp(H/30);
	CX = end[0] - start[0];
	CY = end[1] - start[1];
	CZ = end[2] - start[2];
	XA = (CX/blocks);
	YA = (CY/blocks);
	ZA = (CZ/height);
	TXA = (XA/4);
	TYA = (YA/4);
	Temp = VectorToAngles(end - start);
	Angle = (0, Temp[1], 90);
	for(h = 0; h < height; h++){
		block = spawn("script_model", (start + (TXA, TYA, 10) + ((0, 0, ZA) * h)));
		block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		for(i = 1; i < blocks; i++){
			block = spawn("script_model", (start + ((XA, YA, 0) * i) + (0, 0, 10) + ((0, 0, ZA) * h)));
			block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
			block.angles = Angle;
			block Solid();
			block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		}
		block = spawn("script_model", ((end[0], end[1], start[2]) + (TXA * -1, TYA * -1, 10) + ((0, 0, ZA) * h)));
		block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	}
}

CreateBridge(point1, point2, point3)
{
	points = [];
	points[0] = point1;
	points[1] = point2;
	points[2] = point3;
	for(i = 0; i < points.size; i++){
		if(!isDefined(points[i+1])){
			return;
		}
		D = Distance(points[i], points[i+1]);
		blocks = roundUp(D/30);
		CX = points[i][0] - points[i+1][0];
		CY = points[i][1] - points[i+1][1];
		CZ = points[i][2] - points[i+1][2];
		XA = CX/blocks;
		YA = CY/blocks;
		ZA = CZ/blocks;
		CXY = Distance((points[i][0], points[i][1], 0), (points[i+1][0], points[i+1][1], 0));
		Temp = VectorToAngles(points[i] - points[i+1]);
		BA = (Temp[2], Temp[1] + 90, Temp[0]);
		for(b = 0; b <= blocks; b++){
			block = spawn("script_model", (points[i+1] + ((XA, YA, ZA) * b)));
			block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
			block.angles = BA;
			block Solid();
			block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		}
	}
}
CreateAdaptWalls(start, end, height, offset)
{
	D = Distance((start[0], start[1], 0), (end[0], end[1], 0));
	blocks = roundUp(D/55);
	CX = end[0] - start[0];
	CY = end[1] - start[1];
	XA = (CX/blocks);
	YA = (CY/blocks);
	ZA = 30;
	TXA = (XA/4);
	TYA = (YA/4);
	Temp = VectorToAngles(end - start);
	Angle = (0, Temp[1], 90);
	tempstart = bulletTrace(start, start + (0, 0, 100000), false, undefined)["position"] - (0,0,500);
	tempend = bulletTrace(end, end + (0, 0, 100000), false, undefined)["position"] - (0,0,500);
	for(h = 0; h < height; h++){
		spawnlocation = bulletTrace(tempstart, tempstart - (0, 0, 100000), false, undefined)["position"];
		block = spawn("script_model", (spawnlocation + (TXA, TYA, 15 + offset)));
		block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		
		for(i = 1; i < blocks; i++){
			spawnlocation = bulletTrace(tempstart + ((XA, YA, 0) * i), tempstart + ((XA, YA, 0) * i) - (0, 0, 100000), false, undefined)["position"];
			block = spawn("script_model", (spawnlocation + (0, 0, 15 + offset)));
			block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
			block.angles = Angle;
			block Solid();
			block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
			
		}
		spawnlocation = bulletTrace(tempend, tempend - (0, 0, 100000), false, undefined)["position"];
		block = spawn("script_model", (spawnlocation + (TXA * -1, TYA * -1, 15 + offset)));
		block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		
	}
}

CreateIWall(start, end)
{
	D = Distance((start[0], start[1], 0), (end[0], end[1], 0));
	H = Distance((0, 0, start[2]), (0, 0, end[2]));
	blocks = roundUp(D/55);
	height = roundUp(H/30);
	CX = end[0] - start[0];
	CY = end[1] - start[1];
	CZ = end[2] - start[2];
	XA = (CX/blocks);
	YA = (CY/blocks);
	ZA = (CZ/height);
	TXA = (XA/4);
	TYA = (YA/4);
	Temp = VectorToAngles(end - start);
	Angle = (0, Temp[1], 90);
	for(h = 0; h < height; h++){
		block = spawn("script_model", (start + (TXA, TYA, 10) + ((0, 0, ZA) * h)));
		//block setModel("tag_origin");
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		
		for(i = 1; i < blocks; i++){
			block = spawn("script_model", (start + ((XA, YA, 0) * i) + (0, 0, 10) + ((0, 0, ZA) * h)));
			//block setModel("tag_origin");
			block.angles = Angle;
			block Solid();
			block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
			
		}
		block = spawn("script_model", ((end[0], end[1], start[2]) + (TXA * -1, TYA * -1, 10) + ((0, 0, ZA) * h)));
		//block setModel("tag_origin");
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		
	}
}

CreateCluster(amount, pos, radius)
{
	for(i = 0; i < amount; i++)
	{
		half = radius / 2;
		power = ((randomInt(radius) - half), (randomInt(radius) - half), 500);
		block = spawn("script_model", pos + (0, 0, 1000) );
		block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = (90, 0, 0);
		block PhysicsLaunchServer((0, 0, 0), power);
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	}
}

CreateDoor(type, open, close, angle, size, height, hp, range)
{
	door = spawn("script_origin", open );
	door.state = "open";
	door.hp = hp;
	door.range = range;
	door.type = type;
	door.usingdoor = [];
	if(door.type == "force"){
		door.object = level.spawnGlowModel["enemy"];
		door.effect = level.customFX["force_field"];
	}
	else{
		door.object = "com_plasticcase_enemy";
		door.effect = level.customFX["red_blink_light"];
	}
	offset = (((size / 2) - 0.5) * -1);
	for(j = 0;j < size;j++)
	{
		doorPart = spawn("script_model", open + ((0, 30, 0) * offset));
		doorPart Solid();
		doorPart setModel(door.object);
		doorPart CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		doorPart LinkTo(door);
		doorPart thread ForceEffect(door);
		doorPart thread monitorDestroyFX(door);
		doorPart thread doorDamage(door);
		for(h = 1;h < height;h++)
		{
			doorPart = spawn("script_model", open + ((0, 30, 0) * offset) - ((70, 0, 0) * h));
			doorPart Solid();
			doorPart setModel(door.object);
			doorPart CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
			doorPart LinkTo(door);
			doorPart thread ForceEffect(door);
			doorPart thread monitorDestroyFX(door);
			doorPart thread doorDamage(door);
		}
		offset += 1;
	}
	door.angles = angle;
	door.open = open;
	door.close = close;
	door thread doorLogic(range);
	door thread monitorDeath(open);
	//door thread doorMove(open, close);
}

monitorDeath(open){
	while(self.state != "broken"){
		if(self.hp <= 0){
			self notify("door_broken");
			self.state = "broken";
			self thread AngrySounds();
			self MoveTo(open, level.doorWaitTime);
		}
		wait 1;
	}
}

doorDamage(door)
{
	door endon("door_broken");
	self setCanDamage(true);
	self.maxhealth = 100000;
	self.health = 100000;
	while(door.hp > 0)
	{
		self waittill( "damage", damage, attacker, direction_vec, point, type);
		if(attacker.team == "axis" && type == "MOD_MELEE" && !door.usingdoor[attacker getEntityNumber()])
		{
			if(door.state == "close")
			{
				door.hp--;
				attacker playLocalSound( "elev_bell_ding" );
				attacker iPrintlnBold("HIT!");
				attacker thread user_scripts\mp_patches\hawkins\hud::scorePopup( 5, 0, (25.5, 25.5, 3.6), 1 );
				attacker iPrintln("^3" + door.hp + "^1:HP Left");
			}
		}
		if(attacker.team == "allies" && type == "MOD_MELEE" && !door.usingdoor[attacker getEntityNumber()])
			door thread moveDoor("DoorDamage", self.name);
		wait 0.025;
	}
}

//old and broken somehow.
doorMove(open, close){
	self endon("door_broken");
	while(self.hp > 0){
		self.doorMoving = false;
		self waittill("move_door");
		if(self.origin == close && !self.doorMoving){
			self.doorMoving = true;
			self.state = "open";
			self notify("door_moved");
			self MoveTo(open, level.doorWaitTime);
			wait level.doorWaitTime;
		}
		else if(self.origin == open && !self.doorMoving){
			self.doorMoving = true;
			self MoveTo(close, level.doorWaitTime);
			wait level.doorWaitTime;
			self thread SecureSounds();
			self.state = "close";
			self notify("door_moved");
		}
		wait 1;
	}
}

moveDoor(reason, player){
	if(getDvarInt("dev_mode")){
		iPrintln("Door moved at " + self.origin + " for reason: "+reason);
		iprintln("Door moved by: "+player);
	}
		
	if(!self.doorMoving)
	{
		if(self.origin == self.close){
			self.doorMoving = true;
			self.state = "open";
			self notify("door_moved");
			self MoveTo(self.open, level.doorWaitTime);
			wait level.doorWaitTime;
			self.doorMoving = false;
		}
		else{
			self.doorMoving = true;
			self MoveTo(self.close, level.doorWaitTime);
			wait level.doorWaitTime;
			self thread SecureSounds();
			self.state = "close";
			self.doorMoving = false;
			self notify("door_moved");
		}
	}
}

SecureSounds()
{
	wait 1;
	switch(randomInt(2))
	{
	    case 0:
		self playsound("US_mp_stm_areasecure");
		break;
		case 1:
		self playsound("UK_mp_stm_areasecure");
		break;
	}
}

AngrySounds()
{
	if(!self.warnedHumans)
	{
		self.warnedHumans = true;
		switch(randomInt(2))
		{
			case 0:
			self playsound("US_mp_cmd_fallback");
			break;
			case 1:
			self playsound("UK_mp_cmd_fallback");
			break;
		}
	}
}

doorLogic(range){
	while(1){
		foreach(player in level.players){
			if(Distance(self.origin, player getTagOrigin("j_head")) < range && !self.usingdoor[player getEntityNumber()] && isAlive(player)){
				self.usingdoor[player getEntityNumber()] = true;
				player notify("door_loop_protection");
				player thread useDoor(self);
			}
			else if(Distance(self.origin, player getTagOrigin("j_head")) > range && self.usingdoor[player getEntityNumber()]){
				self.usingdoor[player getEntityNumber()] = false;
				player setSafeMSGText("");
			}
		}
		wait 0.025;
	}
}

useDoor(door){
	door endon("door_broken");
	self endon("door_loop_protection");
	self thread showDoorStatus(door);
	while(door.usingDoor[self getEntityNumber()] && door.hp > 0){
		if(self meleeButtonPressed() && self.team == "allies" && self.guid != undefined){
			door thread moveDoor("useDoor", self.name);
			wait level.doorWaitTime;
		}
		else if(self meleeButtonPressed() && self.team == "axis" && self.guid != undefined){
			if(door.state == "close")
			{
				door.hp--;
				self.money += 5;
				self playLocalSound( "elev_bell_ding" );
				self iPrintlnBold("HIT!");
				self thread user_scripts\mp_patches\hawkins\hud::scorePopup( 5, 0, (25.5, 25.5, 3.6), 1 );
				self iPrintln("^3" + door.hp + "^1:HP Left");
			}
			wait 1;
		}
		else if(self useButtonPressed()){
			self iPrintlnBold("^3" + door.hp + "^1:HP Left");
			wait 1;
		}
		wait 0.025;
	}
}

showDoorStatus(door){
	if(door.type == "force")
		doorName = "ForceField";
	else
		doorName = "Door";
	if(self.team == "allies")
	{
		if(Door.state == "open")
			self setSafeMSGText("^1[{+melee}] ^7to ^2Close ^3"+doorName);
		else if(Door.state == "close")
			self setSafeMSGText("^1[{+melee}] to ^2Open ^3"+doorName+". [{+activate}] Shows HP.");
		else if(Door.state == "broken")
			self setSafeMSGText("^1"+doorName+" is Broken");
	}
	if(self.team == "axis")
	{
		if(Door.state == "close")
			self setSafeMSGText("^1[{+melee}] ^7to ^1Damage ^3the "+doorName+". [{+activate}] Shows HP.");
		else if(Door.state == "broken")
			self setSafeMSGText("^1"+doorName+" is Broken");
	}
}

ForceEffect(door){
	door endon("door_broken");
	self.forceEffect = [];
	self.forceEffect[0] = SpawnFx(door.effect, self.origin);
	self.forceEffect[1] = SpawnFx(door.effect, self.origin);
	while(door.hp > 0)
	{
		door waittill("door_moved");
		if(door.state == "close")
			self thread showDoorEffects(door);
		else
		{
			if(door.type == "force")
				self show();
			foreach(effect in self.forceEffect)
				effect hide();
		}
		wait 0.025;
	}
}

monitorDestroyFX(door){
	while(door.hp > 0)
		wait 0.1;
	if(door.type == "force")
		self show();
	foreach(effect in self.forceEffect)
		effect hide();
}

showDoorEffects(door){
	if(door.type == "force")
		self hide();
	self.forceEffect[0] show();
	self.forceEffect[0].angles = (-270,0,0);
	self.forceEffect[1] show();
	self.forceEffect[1].angles = (270,0,0);
	TriggerFX(self.forceEffect[0]);
	TriggerFX(self.forceEffect[1]);
	if(self.forceEffect[0].origin != (self.origin+(0,0,35)))
		self.forceEffect[0].origin = (self.origin+(0,0,35));
	if(self.forceEffect[1].origin != (self.origin-(0,0,50)))
		self.forceEffect[1].origin = (self.origin-(0,0,50));
}

SecretObjects()
{
	l = self;
	l.array = [];
	map = getDvar("mapname");
	switch(map)
	{
		case "mp_subbase":
		l.array[0] = (-527, -1847, 101);
		
		break;
		
		case "mp_checkpoint":/*karachi*/
		l.array[0] = (-881, 840, 82);
		
		break;
		
		case "mp_estate":
		l.array[0] = (495, 1343, 250);
	
		break;
		
		case "mp_derail":
		l.array[0] = (399, 377, 169);
	
		break;
		
		case "mp_afghan":
		l.array[0] = (4045, 1227, 216);
		
		break;
		
		case "mp_favela":
		l.array[0] = (881, 1926, 228);
		
		break;
		
		case "mp_highrise":
		l.array[0] = (-1281, 6601, 2836);

		break;
		
		case "mp_invasion":
		l.array[0] = (1410.03, -1355.7, 432.125);
		
		break;
		
		case "mp_quarry":
		l.array[0] = (-1694, 727, 84);
		
		break;
		
		case "mp_rundown":
		l.array[0] = (1159, 2672, 126);
		
		break;
		
		case "mp_rust":
		l.array[0] = (729.18, 416.875, -239.875);
		break;
		
		case "mp_boneyard":/*scrapyard*/
		l.array[0] = (819, -447, -80);
		break;
		
		case "mp_nightshift":
		l.array[0] = (1218, -1319, 52);
		l.array[1] = (-223.125, -848.515, 136.125);
		break;
		
		case "mp_terminal":
		l.array[0] = (4, 5277, 253);
		break;
		
		case "mp_underpass":
		l.array[0] = (2159, 486, 348);
		
		break;
		
		case "mp_brecourt":/*wasteland*/
		l.array[0] = (75, 1964, 69);
		
		break;
		
		default: break;
	}
	l thread spawnSecretObjects(l.array[randomint(l.array.size)]);
}
spawnSecretObjects(enter)
{
	self endon("disconnect");
	level.init_once = spawn( "trigger_radius", enter, 0, 50, 50 );
	level.init_once thread triggerWaitSecretObjects(enter);
}

triggerWaitSecretObjects(location_spot)
{
	self endon("death");
	level endon("game_ended");
	level.secret = 0;
	while(isdefined(self))
	{
		self waittill( "trigger", player );
		radius = distance2d(player.origin,location_spot);
		if(distance2d(player.origin,location_spot) < 50)
		{
			if(level.secret == 0)
			{
				player setSafeMSGText("Hold [{+activate}] for Secrets And $");
				if(player useButtonPressed())
				{
					player thread foundSecret();
				}
			}
		}
	wait 0.2;
	}
}

foundSecret()
{
	self setSafeMSGText("");
	level.secret = 1;
	for(i=10;i>0;i--)
	{
		self playsound( "ui_mp_nukebomb_timer" );
		wait 1;
	}
		self thread user_scripts\mp_patches\hawkins\menuUtils::freezeZombies();
		wait 2;
		iprintlnBold(self.name+" Found The Secret Object And Awarded Everyone $200!");
	foreach(player in level.players)
	{	
		player.MZ += 200;
		player notify("update_menu");
	}
}

roundUp( floatVal )
{
	if ( int( floatVal ) != floatVal )
		return int( floatVal+1 );
	else
		return int( floatVal );
}



/* MAP FUNCTIONS END*/